/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.rift.network;

import io.netty.buffer.Unpooled;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import org.dimdev.rift.network.ClientMessageContext;
import org.dimdev.rift.network.ServerMessageContext;
import org.dimdev.rift.util.RegistryUtil;

public abstract class Message {
    public static final fc<Class<? extends Message>> REGISTRY = RegistryUtil.createRegistry(new pc("rift", "message"), new ey());

    public abstract void write(hy var1);

    public abstract void read(hy var1);

    public void process(ClientMessageContext context) {
        throw new UnsupportedOperationException("Packet " + this.getClass() + " can't be processed on client.");
    }

    public void process(ServerMessageContext context) {
        throw new UnsupportedOperationException("Packet " + this.getClass() + " can't be processed on server.");
    }

    public final iv<? extends ib> toPacket(iw direction) {
        pc id = REGISTRY.b(this.getClass());
        if (id == null) {
            throw new IllegalArgumentException("Message was not registered: " + this);
        }
        hy buffer = new hy(Unpooled.buffer());
        this.write(buffer);
        switch (direction) {
            case b: {
                return new jy(id, buffer);
            }
            case a: {
                return new mp(id, buffer);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public final void send(aog player) {
        if (player instanceof tf) {
            ((tf)player).a.a().a(this.toPacket(iw.b));
        } else if (player instanceof ctj) {
            ((ctj)player).d.a().a(this.toPacket(iw.a));
        } else {
            throw new IllegalArgumentException("Only supported for EntityPlayerMP and EntityPlayerSP, but got " + player.getClass());
        }
    }

    public final void sendToAll(MinecraftServer server) {
        for (tf player : server.ac().v()) {
            this.send((aog)player);
        }
    }

    public final void sendToAll(MinecraftServer server, Predicate<tf> filter) {
        for (tf player : server.ac().v()) {
            if (!filter.test(player)) continue;
            this.send((aog)player);
        }
    }

    public final void sendToAll(td world, Predicate<tf> filter) {
        for (tf player : world.b(tf.class, filter)) {
            this.send((aog)player);
        }
    }

    public final void sendToAll(td world) {
        for (tf player2 : world.b(tf.class, player -> true)) {
            this.send((aog)player2);
        }
    }

    public void sendToServer() {
        cft.s().i.d.a(this.toPacket(iw.a));
    }
}

