/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.rift;

import java.io.IOException;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.riftloader.listener.InitializationListener;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IEnvironmentTokenProvider;

public class Rift
implements InitializationListener {
    public static final int DATAFIXER_VERSION = 1631;
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void onInitialization() {
        LOGGER.info("Loading Rift!");
        MixinBootstrap.init();
        Mixins.addConfiguration((String)"mixins.rift.core.json");
        Mixins.addConfiguration((String)"mixins.rift.hooks.json");
        MixinEnvironment.getDefaultEnvironment().registerTokenProviderClass("org.dimdev.rift.Rift$RiftTokens");
    }

    public static class RiftTokens
    implements IEnvironmentTokenProvider {
        public static boolean isObf = RiftTokens.isObf();
        public static boolean hasOptifine = false;

        private static boolean isObf() {
            try {
                return Launch.classLoader.getClassBytes("net.minecraft.world.World") == null;
            }
            catch (IOException e) {
                return true;
            }
        }

        public int getPriority() {
            return 1000;
        }

        public Integer getToken(String token, MixinEnvironment env) {
            switch (token) {
                case "OBF": {
                    return isObf ? 1 : 0;
                }
                case "OPTIFINE": {
                    return hasOptifine ? 2 : 0;
                }
            }
            return null;
        }
    }
}

